% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cna.R
\name{plot.cna}
\alias{plot.cna}
\alias{plot.condTbl}
\alias{plot.condList}
\title{Create hypergraphs from solution objects of \code{\link[cna]{cna}()} and related functions}
\usage{
\method{plot}{condTbl}(x, outcome = NULL, n = 10, ask = nrow(x) > 1, ...)

\method{plot}{cna}(x, what = c("csf", "asf", "msc"), ...)

\method{plot}{condList}(x, ...)
}
\arguments{
\item{x}{An object of an appropriate class.}

\item{outcome}{Character vector of factor names. Only solutions with one of these factors as outcome 
will be plotted. If \code{NULL} (default), all solutions are plotted.}

\item{n}{Positive integer; specifies the maximal number of graphs to render.}

\item{ask}{Logical; if \code{TRUE}, the user is asked to hit <Return> before a new graph is drawn.}

\item{\dots}{Additional arguments in \code{plot.condTbl()} are passed to 
\code{\link[causalHyperGraph]{causalHyperGraph}()}, in particular \code{show_formula}. 
Additional arguments in \code{plot.cna()} and \code{plot.condition()} 
are passed to \code{plot.condTbl()}, e.g. \code{n}, \code{outcome}, \code{ask}.}

\item{what}{One of \code{"csf"} (default), \code{"asf"}, \code{"msc"}, determining which type of solution to 
extract from the \dQuote{cna} object.}
}
\value{
These \code{plot()} methods return an object of class \dQuote{\link[causalHyperGraph]{causalHyperGraph}}.
}
\description{
These \code{plot()} methods draw causal hypergraphs from the solution formulas included 
in the objects of the following classes
from package \CRANpkg{cna}:
\itemize{
\item{class \dQuote{cna}, the output of \code{\link[cna]{cna}()};}
\item{class \dQuote{condTbl}, the output of \code{\link[cna]{condTbl}()}, 
\code{\link[cna]{csf}()}, \code{\link[cna]{asf}()} and \code{\link[cna]{msc}()};}
\item{class \dQuote{condList}, the output of \code{\link[cna]{condition}()}.}
}
}
\examples{
library(cna)

ana <- cna(d.educate)
pl <- plot(asf(ana))
pl

plot(csf(ana))
plot(csf(ana), ask = FALSE)

plot(ana)
plot(ana, show_formula = TRUE)
plot(ana, what = "msc", n = 5)

plot(msc(ana), outcome = "E")
plot(ana, what = "msc", outcome = "E")  # same as previous

}
