% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_genes_or_panel.R
\name{get_entrez_id}
\alias{get_entrez_id}
\title{Get Entrez Gene ID for a given set of Hugo Symbols}
\usage{
get_entrez_id(hugo_symbol = NULL, base_url = NULL)
}
\arguments{
\item{hugo_symbol}{a character vector of Hugo Symbols}

\item{base_url}{The database URL to query}
}
\value{
A dataframe with Entrez Gene IDs and Hugo Symbols
}
\description{
Get Entrez Gene ID for a given set of Hugo Symbols
}
\examples{
\dontrun{
get_entrez_id(hugo_symbol = "TAP1", base_url = 'www.cbioportal.org/api')
get_entrez_id(hugo_symbol = c("FGFR1", "TP53") , base_url = 'www.cbioportal.org/api')
}
}
