% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{stepPairs}
\alias{stepPairs}
\title{Find Pairs of Steps Occurring at the Same Time}
\usage{
stepPairs(X, filter.steps = NULL)
}
\arguments{
\item{X}{a tracks object}

\item{filter.steps}{optional: a function used to filter steps on. See examples.}
}
\value{
A dataframe with three columns: two for the indices of cellpairs that
share a step, and one for the timepoint at which they do so.
}
\description{
Find cell indices and timepoints where these cells both have a step.
}
\examples{
## Find all pairs of steps in the T cell data that displace at least 2 microns.
pairs <- stepPairs( TCells, filter.steps = function(t) displacement(t) > 2 )

}
