% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tracts.R
\name{read_tracts}
\alias{read_tracts}
\title{Download census tract-level data from Brazil's censuses}
\usage{
read_tracts(
  year,
  dataset,
  as_data_frame = FALSE,
  showProgress = TRUE,
  cache = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{year}{Numeric. Year of reference in the format \code{yyyy}.}

\item{dataset}{Character. The dataset to be opened. The following options are
available for each edition of the census:

\strong{2000 Census}
\itemize{
\item \code{c("Basico", "Domicilio", "Responsavel", "Pessoa", "Instrucao", "Morador")}.
}

\strong{2010 Census}
\itemize{
\item \code{c("Basico", "Domicilio", "DomicilioRenda", "Responsavel", "ResponsavelRenda", "Pessoa", "PessoaRenda", "Entorno")}.
}

\strong{2022 Census}
\itemize{
\item \code{c("Basico", "Domicilio", "ResponsavelRenda", "Pessoas", "Indigenas", "Quilombolas", "Entorno", "Obitos", "Preliminares")}.
}

The \code{censobr} package exposes all original IBGE census tracts datasets, regrouping
them into broader themes and appending geographic identifiers so that they
align seamlessly with \code{geobr} shapefiles.

For a complete description of the datasets, themes, and variables, check
\itemize{
\item \code{data_dictionary(year = 2000, dataset = "tracts")},
\item \code{data_dictionary(year = 2010, dataset = "tracts")},
\item \code{data_dictionary(year = 2022, dataset = "tracts")}.
}}

\item{as_data_frame}{Logical. When \code{FALSE} (Default), the function returns an
Arrow Dataset, which allows users to work with larger-than-memory data.
If \code{TRUE}, the function returns \code{data.frame}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display download progress
bar. The progress bar only reflects only the downloading
time, not the time to load the data to memory.}

\item{cache}{Logical. Whether the function should read the data cached
locally, which is much faster. Defaults to \code{TRUE}. The first time the
user runs the function, \code{censobr} will download the file and store it
locally so that the file only needs to be download once. If \code{FALSE},
the function will download the data again and overwrite the local file.}

\item{verbose}{A logical. Whether the function should print informative
messages. Defaults to \code{TRUE}.}
}
\value{
An arrow \code{Dataset} or a \code{"data.frame"} object.
}
\description{
Download census tract-level aggregate data from Brazil's censuses.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(censobr)

# return data as arrow Dataset
df <- read_tracts(
  year = 2022,
  dataset = 'Domicilio',
  showProgress = FALSE
  )

# return data as data.frame
df <- read_tracts(
  year = 2010,
  dataset = 'Basico',
  as_data_frame = TRUE,
  showProgress = FALSE
  )
\dontshow{\}) # examplesIf}
}
\concept{Census tract data}
