% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebuild.R
\name{rebuild}
\alias{rebuild}
\alias{rebuild.data.frame}
\alias{rebuild.data.table}
\alias{rebuild.tbl_df}
\alias{rebuild.sf}
\title{Rebuild an object from a template}
\usage{
rebuild(x, template, ...)

\method{rebuild}{data.frame}(x, template, shallow_copy = TRUE, ...)

\method{rebuild}{data.table}(x, template, shallow_copy = TRUE, ...)

\method{rebuild}{tbl_df}(x, template, shallow_copy = TRUE, ...)

\method{rebuild}{sf}(x, template, shallow_copy = TRUE, ...)
}
\arguments{
\item{x}{An object in which carefully selected attributes
will be copied into from \code{template}.}

\item{template}{A template object used to copy attributes into \code{x}.}

\item{...}{Further arguments passed onto methods.}

\item{shallow_copy}{Should \code{x} be shallow copied before rebuilding?
Default is \code{TRUE}.}
}
\value{
An object similar to \code{template}.
}
\description{
Rebuild an object from a template
}
\details{
In R attributes are difficult to work with. One big reason for this is
that attributes may or may not be independent of the data.
Date vectors for example have attributes completely independent of the data
and hence if the attributes are removed at any point, they can easily be
re-added without any calculations. Factors have almost data-independent
attributes with an exception being when factors are combined.
In some cases it is not possible to rebuild attributes from the data
alone.

You can add your own \code{rebuild} method for an object not covered
by the methods here.
}
