# WARNING - Generated by {fusen} from dev/flat_check_as_cran.Rmd: do not edit by hand

#' Check your package with real CRAN default environment variables and check strategy
#'
#' @description
#' `r lifecycle::badge("experimental")`
#'
#' @param pkg pkg directory to check
#' @param check_output Where to store check outputs. Default is a temporary directory
#' @param scratch Where to store temporary files (cleaned after). Default is another temporary directory
#' @param Ncpus Number of CPU used to build the package
#' @param as_command Whether to run the check as Linux command line, instead of directly in R
#' @param clean_before Whether to delete the previous check_output
#' @param open Whether to open the check dir at the end of the process
#'
#' @return An object containing errors, warnings, and notes.
#'
#' @details
#' When you send your package on CRAN, there are multiple options set before running the checks.
#' Here we use the CRAN settings and way of managing incoming packages used for Linux in this function `check_as_cran()`.
#'
#' Scripts and options used are directly issued from the GitHub mirror repository of the CRAN machines: <https://github.com/r-devel/r-dev-web/tree/master/CRAN/>.
#' Although `check_as_cran()` should run on any OS, it will run CRAN parameters originally set up for Linux machines.
#'
#' In the `check_output`, you will get the same outputs, in the same format as used by CRAN, for the pre-test of incoming packages.
#'
#' @references https://github.com/r-devel/r-dev-web/tree/master/CRAN/
#' @export
#'
#' @examples
#' \dontrun{
#' # This runs a check of the current package
#' # Directory to store the check outputs
#' check_output <- tempfile("example")
#' # Check the current package
#' check_as_cran(check_output = check_output)
#' # Open directory with all outputs
#' utils::browseURL(check_output)
#' }
check_as_cran <- function(pkg = ".", check_output = tempfile("check_output"),
                          scratch = tempfile("scratch_dir"),
                          Ncpus = 1, as_command = FALSE,
                          clean_before = TRUE,
                          open = FALSE) {
  pkg <- normalizePath(pkg)

  if (isTRUE(clean_before) | !dir.exists(check_output)) {
    if (dir.exists(check_output)) {
      unlink(check_output, recursive = TRUE)
    }
    dir.create(check_output)
  }

  if (dir.exists(scratch)) {
    unlink(scratch, recursive = TRUE)
  } else {
    dir.create(scratch)
  }

  results <- the_check(
    pkg = pkg,
    check_output = check_output,
    scratch = scratch,
    Ncpus = Ncpus,
    clean_before = clean_before
  )

  writeLines("\nDepends:")
  tools::summarize_check_packages_in_dir_depends(check_output)
  writeLines("\nTimings:")
  tools::summarize_check_packages_in_dir_timings(check_output)
  writeLines("\nResults:")
  tools::summarize_check_packages_in_dir_results(check_output)
  writeLines("\nDetails:")
  tools::check_packages_in_dir_details(check_output)
  message("\nSee all check outputs in: ", check_output)

  if (isTRUE(open)) {
    utils::browseURL(check_output)
  }
  return(results)
}


#' @noRd
the_check <- function(pkg = ".", check_output, scratch, Ncpus = 1, as_command = FALSE, clean_before = TRUE) {
  pkgbuild::build(path = pkg, dest_path = check_output)

  envfile <- system.file("cran/CRAN_incoming/check.Renviron", package = "checkhelper")
  # read.table does not read comment, which is good
  envfile_table <- utils::read.table(envfile, sep = "=")
  env_values <- as.list(t(envfile_table)[2, ])
  names(env_values) <- as.list(t(envfile_table)[1, ])

  lib_dir <- system.file("cran/lib", package = "checkhelper")

  withr::with_envvar(new = env_values, {
    if (!as_command) {
      Sys.setenv("TMPDIR" = scratch)
      cran_check_unique(check_output, lib_dir, scratch, Ncpus)
    } else {
      message("This may only run on Linux OS with sh")
      # Run as command line for Linux only
      lib_bin <- system.file("cran/bin", package = "checkhelper")
    }
  })
}
