% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifiers.R
\name{less_than}
\alias{less_than}
\title{Facilitate "Less Than" Comparison on Logical Vectors}
\usage{
less_than(logical_vec, p = NULL, n = NULL, na.rm = FALSE)
}
\arguments{
\item{logical_vec}{A logical vector.}

\item{p}{Proportion value (0 to 1) to compare against.}

\item{n}{Count value (integer) to compare against.}

\item{na.rm}{Logical. Should missing values be removed before calculation?}
}
\value{
\code{TRUE} if the condition is met for less than the specified
proportion or count, otherwise \code{FALSE}.
}
\description{
This function facilitates a comparison to check if less than a specified
proportion or count of values in a logical vector
evaluate to \code{TRUE}.
}
\examples{
# Check if less than 10\% of values are TRUE
less_than(c(TRUE, FALSE, FALSE), p = 0.1) # Returns FALSE

}
\seealso{
Other basic_quantifiers: 
\code{\link{at_least}()},
\code{\link{at_most}()},
\code{\link{exactly_equal}()},
\code{\link{more_than}()}
}
\concept{basic_quantifiers}
