% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifiers.R
\name{prop}
\alias{prop}
\title{Calculate Proportion of TRUE Values in a Logical Vector}
\usage{
prop(logical_vec, na.rm = FALSE)
}
\arguments{
\item{logical_vec}{A logical vector.}

\item{na.rm}{Logical. Should missing values be removed before calculation?
Behaves similar to \code{base::mean}, removing missing values
from both the numerator and denominator of the proportion
calculation.}
}
\value{
The proportion of \code{TRUE} values in the logical vector.
}
\description{
This function calculates the proportion of \code{TRUE} values in a logical
vector.
}
\examples{
prop(c(TRUE, TRUE, FALSE, TRUE)) # Returns 0.75
prop(c(TRUE, FALSE, TRUE, FALSE, NA), na.rm = TRUE) # Returns 0.5

}
\keyword{exported}
