% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheetah_utils.R
\name{number_format}
\alias{number_format}
\alias{date_format}
\title{Column formatter}
\usage{
number_format(
  style = c("decimal", "currency", "percent", "unit"),
  currency = NULL,
  currency_display = c("symbol", "code", "narrowSymbol", "name"),
  currency_sign = c("standard", "accounting"),
  unit = NULL,
  unit_display = c("short", "narrow", "long"),
  locales = NULL,
  locale_options = NULL,
  digit_options = NULL,
  other_options = NULL
)

date_format(
  locales = NULL,
  day = c("numeric", "2-digit"),
  year = c("numeric", "2-digit"),
  hour = c("numeric", "2-digit"),
  minute = c("numeric", "2-digit"),
  second = c("numeric", "2-digit"),
  month = c("numeric", "2-digit", "long", "short", "narrow"),
  weekday = c("long", "short", "narrow"),
  day_period = c("narrow", "long", "short"),
  hour12 = FALSE,
  time_zone = NULL,
  date_style = c("none", "full", "long", "medium", "short"),
  time_style = c("none", "full", "long", "medium", "short"),
  more_date_options = NULL,
  locales_date_options = NULL
)
}
\arguments{
\item{style}{The formatting style to use. Must be one of the following:
\itemize{
\item \code{"decimal"} for plain number formatting action columns. Default.
\item \code{"currency"} for currency formatting
\item \code{"percent"} for percent formatting.
\item \code{"unit"} for unit formatting.
}}

\item{currency}{The ISO 4217 currency code to use for currency formatting. Must be provided if \code{style} is \code{"currency"}.}

\item{currency_display}{The display format for the currency. Must be one of the following:
\itemize{
\item \code{"symbol"} for the currency symbol. Default. Use the localized currency symbol e.g. $ for USD.
\item \code{"code"} for the currency code. Use the ISO 4217 currency code e.g. USD for US Dollar.
\item \code{"narrowSymbol"} for the narrow currency symbol. Use the narrow currency symbol e.g. \verb{$100} instead of \verb{$USD100}.
\item \code{"name"} for the currency name. Use the localized currency name e.g. Dollar for USD.
}}

\item{currency_sign}{The sign to use for the currency. Must be one of the following:
\itemize{
\item \code{"standard"} for the standard format. Default.
\item \code{"accounting"} for the accounting format. Use the accounting sign e.g. $100 instead of $USD100.
}}

\item{unit}{The unit to use for the unit formatting. Must be provided if \code{style} is \code{"unit"}.}

\item{unit_display}{The display format for the unit. Must be one of the following:
\itemize{
\item \code{"short"} for the short format. Default. E.g., 16 l
\item \code{"narrow"} for the narrow format. E.g., 16l
\item \code{"long"} for the long format. E.g., 16 liters
}}

\item{locales}{A character vector of BCP 47 language tags (e.g. \code{"en-US"} for English,
\code{"ja-JP"} for Japanese) specifying the locales to use for formatting.
If NULL, the runtime's default locale is used. See
\href{https://learn.microsoft.com/en-us/openspecs/office_standards/ms-oe376/6c085406-a698-4e12-9d4d-c3b0ee3dbc4a}{BCP 47 language tags}
for reference.}

\item{locale_options}{A named list of options to customize the locale.}

\item{digit_options}{A named list of options to customize the digit.}

\item{other_options}{A named list of other options to customize the number formatting.}

\item{day, month, year, hour, minute, second}{The format to use for the day, month,
year, hour, minute, and second. The possible values are \code{"numeric"}, and \code{"2-digit"}
except month, with more options i.e \code{"long"}, \code{"short"}, and \code{"narrow"}.
Default for all is \code{"numeric"}.}

\item{weekday, day_period}{The format to use for the weekday and day period.
The possible values are \code{"long"}, \code{"short"}, and \code{"narrow"}.}

\item{hour12}{Whether to use 12-hour time format or the 24-hour format. Default is FALSE.}

\item{time_zone}{The time zone to use for the date formatting. E.g. \code{"America/New_York"}.}

\item{date_style, time_style}{The format to use for the date and time styles.
The available values are \code{"none"}, \code{"full"}, \code{"long"}, \code{"medium"}, and \code{"short"}.
Note: date_style and time_style can be used together,
but not with other date-time component options like weekday, hour, or month.}

\item{more_date_options}{A named list of other options to customize the date formatting.}

\item{locales_date_options}{A named list of options to customize the locales for the date.
@note
Further details on customizing numeric formatting can be found in the
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/NumberFormat/NumberFormat#parameters}{Intl.NumberFormat documentation}.
Further details on customizing date formatting can be found in the
\href{https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/DateTimeFormat/DateTimeFormat}{Intl.DateTimeFormat documentation}}
}
\value{
For \code{number_format()}: A list containing number formatting options that can be used to format numeric data in a column.
For \code{date_format()}: A list containing date formatting options that can be used to format date data in a column.
}
\description{
Format numeric and date columns using international formatting standards.
Use \code{number_format()} to add data formatting to numeric columns and
\code{date_format()} to format date columns according to the Intl.DateTimeFormat API.
}
\examples{
# Number formatting examples
data <- data.frame(
  price_USD = c(125000.75, 299.99, 7890.45),
  price_EUR = c(410.25, 18750.60, 1589342.80),
  liter = c(20, 35, 42),
  percent = c(0.875, 0.642, 0.238)
)

cheetah(
  data,
  columns = list(
    price_USD = column_def(
      name = "USD",
      column_type = number_format(
        style = "currency",
        currency = "USD"
      )
    ),
    price_EUR = column_def(
      name = "EUR",
      column_type = number_format(
        style = "currency",
        currency = "EUR",
        locales = "de-DE"
      )
    ),
    liter = column_def(
      name = "Liter",
      column_type = number_format(
        style = "unit",
        unit = "liter",
        unit_display = "long"
      )
    ),
    percent = column_def(
      name = "Percent",
      column_type = number_format(style = "percent")
    )
  )
)

# Date formatting examples
date_data <- data.frame(
  date = as.Date(c("2024-01-01", "2024-01-02", "2024-01-03"))
)

cheetah(
  date_data,
  columns = list(
    date = column_def(
      name = "Date",
      column_type = date_format(
        locales = "en-US",
        day = "2-digit",
        month = "long",
        year = "numeric"
      )
    )
  )
)

}
