% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_edge_list.R
\name{create_edge_list}
\alias{create_edge_list}
\title{Create an edge list}
\usage{
create_edge_list(
  nodes,
  method,
  degree = 1,
  directed = FALSE,
  reverse = FALSE,
  self = FALSE
)
}
\arguments{
\item{nodes}{a \code{data.frame} with (at least) the following three columns:
\code{node}, \code{transect}, and \code{quadrats}. Must be the output of the function
\code{\link[=create_node_labels]{create_node_labels()}}.}

\item{method}{a \code{character} of length 1. The method used to detect neighbors.
One among \code{'pawn'}, \code{'fool'}, \code{'rook'}, \code{'bishop'}, \code{'bishop_left'},
\code{'bishop_right'}, \code{'knight'}, \code{'knight_left'}, \code{'knight_right'},
\code{'queen'}, \code{'wizard'}. For further information, see the functions of the
same name (i.e. \code{\link[=pawn]{pawn()}}, \code{\link[=rook]{rook()}}, etc.).}

\item{degree}{an \code{integer} of length 1. The maximum number of neighbors to
search for.}

\item{directed}{a \code{logical} of length 1. If \code{FALSE} (default), search for
neighbors in all directions (undirected network). Otherwise, the network
will be considered as directed according to the orientations of the
network. The default orientation follows the order of node labels in
both axes.}

\item{reverse}{a \code{logical} of length 1. If \code{TRUE}, change the default
orientation of the network. This argument is ignored if \code{directed = FALSE}.
See examples for further detail.}

\item{self}{a \code{logical} of length 1. If \code{TRUE}, a node can be its own
neighbor. Default is \code{FALSE}.}
}
\value{
A \code{data.frame} with \code{n} rows (where \code{n} is the number of edges) and
the following two columns:
\itemize{
\item \code{from}: the node label of one of the two endpoints of the edge
\item \code{to}: the node label of the other endpoint of the edge
}
}
\description{
Creates a list of edges (links) between nodes (sampling units) based on the
detection of neighbors and according to three neighborhood rules:
\enumerate{
\item \strong{Degree of neighborhood} (argument \code{degree}): the number of adjacent
nodes that will be used to create \strong{direct} edges. If \code{degree = 1},
only nodes directly adjacent to the focal node will be considered as
neighbors.
\item \strong{Orientation of neighborhood} (argument \code{method}): can neighbors be
detecting horizontally and/or vertically and/or diagonally? The package
\code{chessboard} implements all possible orientations derived from the chess
game.
\item \strong{Direction of neighborhood} (arguments \code{directed} and \code{reverse}): does
the sampling design has a direction? If so (\code{directed = TRUE}), the network
will be considered as \strong{directed} and the direction will follow the order
of node labels in both axes (except if \code{reverse = TRUE}).
}

It's important to note that, even the package \code{chessboard} is designed to
deal with spatial networks, this function does not explicitly use spatial
coordinates to detect neighbors. Instead it uses the \strong{node labels}. The
function \code{\link[=create_node_labels]{create_node_labels()}} must be used before this function to create
node labels.
}
\examples{
library("chessboard")

# Two-dimensional sampling (only) ----
sites_infos <- expand.grid("transect" = 1:3, "quadrat" = 1:5)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")

edges <- create_edge_list(nodes, method = "pawn", directed = TRUE)
edges

edges <- create_edge_list(nodes, method = "bishop", directed = TRUE)
edges
}
