% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_means.R
\name{plot_means}
\alias{plot_means}
\title{plot_means}
\usage{
plot_means(
  n_patient_vector,
  timepoints,
  pacf_list,
  sigma_ar_vec,
  mean_list,
  beta_list,
  reference_id,
  seed_val,
  threshold,
  total_data,
  covariate_df,
  static_output = FALSE
)
}
\arguments{
\item{n_patient_vector}{Vector of number of patients}

\item{timepoints}{Vector of timepoints (e.g. weeks, days, time indices)}

\item{pacf_list}{List of pacf vectors}

\item{sigma_ar_vec}{Vector of variances per arm associated with list of pacf vectors}

\item{mean_list}{List of vectors of means per arm}

\item{beta_list}{List of vectors of beta coefficients per arm.
All vectors must have the same length and must be the same
as the number of columns for the covariate_df.}

\item{reference_id}{ID for pairwise comparisons, e.g. for three arms,
if reference_id=1, then arms 2 and 3 will be compared only to arm 1}

\item{seed_val}{Starting seed value}

\item{threshold}{Value to dichotomize continuous outcomes on}

\item{total_data}{Total number of clinical trials to simulate}

\item{covariate_df}{Matrix or dataframe of covariates.
Rows correspond to the total number of subjects. Order matters,
For instance, if you want to simulate a trial with 3 arms, each of size 30,50 and 80,
then covariate_df would have 30+50+80 rows such that the first 30 rows are
covariates for arm 1, the next 50 rows are covariates for arm 2
and the last 80 rows are covariates for arm 3.}

\item{static_output}{TRUE, if static and FALSE if dynamic plot is requested}
}
\value{
The plot of raw means.
}
\description{
Plots the means of simulation parameters.
}
\examples{
total_data = 3
reference_id = 1
threshold = NA
timepoints = c(0,24,48,72,96,120,144)
IR_display = TRUE
delta_adjustment_in = c(0,1)

n_patient_ctrl = 120
n_patient_expt = 150
n_patient_vector = c(n_patient_ctrl, n_patient_expt)
n_total = sum(n_patient_vector)

mean_control = c(0,0,0,0,0,0,0)
mean_treatment = c(0,0.1,0.2,0.4,0.6,0.8,1)
mean_list = list(mean_control, mean_treatment)

sigma_ar_vec = c(1, 1)
pacf_list = list(c(-0.2, 0.4),
                 c(-0.2, 0.4))

beta_list = list(c(1.25, 1.25),
                 c(1.25, 1.25))
covariate_df = NA

# LoE & EE
up_good = "Up"
p_loe_max = 0.75
z_l_loe = -7
z_u_loe = -1
p_ee_max = 0.1
z_l_ee = 4
z_u_ee = 10

# Admin & AE

p_admin_ctrl = 0.02
p_admin_expt = 0.02
p_admin = c(p_admin_ctrl, p_admin_expt)

prob_ae_ctrl = 0.7
prob_ae_expt = 0.9
prob_ae = c(prob_ae_ctrl, prob_ae_expt)

rate_dc_ae_ctrl = 0.1
rate_dc_ae_expt = 0.1
rate_dc_ae = c(rate_dc_ae_ctrl, rate_dc_ae_expt)

starting_seed_val = 1
static_output = TRUE

mean_out = plot_means(n_patient_vector = n_patient_vector, timepoints = timepoints,
pacf_list = pacf_list, sigma_ar_vec = sigma_ar_vec, mean_list = mean_list,
beta_list = beta_list, reference_id = reference_id, seed_val = starting_seed_val,
total_data = total_data, threshold = threshold, covariate_df = covariate_df,
static_output = static_output)
}
