% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civ.R
\name{summary.civ}
\alias{summary.civ}
\title{Inference Methods for the Categorical Instrumental Variable Estimator.}
\usage{
\method{summary}{civ}(object, ...)
}
\arguments{
\item{object}{An object of class \code{civ} as fitted by \code{\link[=civ]{civ()}}.}

\item{...}{Additional arguments passed to \code{summary.ivreg}. See
\code{\link[AER:summary.ivreg]{AER::summary.ivreg()}} for a complete list of arguments.}
}
\value{
An object of class \code{summary.ivreg} with inference results.
}
\description{
Inference methods for the categorical instrumental variable
estimators. Simple wrapper for \code{\link[AER:summary.ivreg]{AER::summary.ivreg()}}.
}
\examples{
# Simulate data from a simple IV model with 800 observations
nobs = 800 # sample size
Z <- sample(1:20, nobs, replace = TRUE) # observed instrument
Z0 <- Z \%\% 2 # underlying latent instrument
U_V <- matrix(rnorm(2 * nobs, 0, 1), nobs, 2) \%*\%
  chol(matrix(c(1, 0.6, 0.6, 1), 2, 2)) # first and second stage errors
D <- Z0 + U_V[, 2] # endogenous variable
y <- D + U_V[, 1] # outcome variable
# Estimate categorical instrument variable estimator with K = 2
civ_fit <- civ(y, D, Z, K = 3)
summary(civ_fit)
}
\references{
Fox J, Kleiber C, Zeileis A (2023). "ivreg: Instrumental-Variables Regression
by '2SLS', '2SM', or '2SMM', with Diagnostics". R package.

Wiemann T (2023). "Optimal Categorical Instruments."
}
\seealso{
\code{\link[AER:summary.ivreg]{AER::summary.ivreg()}}
}
