% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{usage_list_llm}
\alias{usage_list_llm}
\title{Get a list of usage statistics for a given organization}
\usage{
usage_list_llm(org_id = NULL, start_date = NULL, end_date = NULL)
}
\arguments{
\item{org_id}{integer optional. The ID of the organization to get usage statistics for.}

\item{start_date}{string optional. The start date of the range to get usage statistics for."\ "Defaults to the start of the current month if neither start_date nor end_date is specified.}

\item{end_date}{string optional. The end date of the range to get usage statistics for."\ "Defaults to the end of the current day if neither start_date nor end_date is specified.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the usage statistic to get.}
\item{runId}{integer, The ID of the run which contributed this usage.}
\item{jobId}{integer, The ID of the job which contributed this usage.}
\item{userId}{integer, The ID of the user who contributed this usage.}
\item{organizationId}{integer, The organization of the user who contributed this usage.}
\item{runCreatedAt}{string, When the run was created at.}
\item{runTime}{integer, The duration of the run in seconds.}
\item{credits}{number, The number of credits used.}
\item{inputTokens}{integer, The number of tokens input to the run.}
\item{outputTokens}{integer, The number of tokens output from the run.}
\item{modelId}{string, The ID of the LLM model used.}
}
\description{
Get a list of usage statistics for a given organization
}
