% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incoming.R
\docType{data}
\name{incoming}
\alias{incoming}
\alias{ciw}
\alias{known_folders}
\title{Report on the incoming queue at CRAN}
\format{\code{known_folders} is an unexported global state variable with a simple vector of
the (currently) known directory names \dQuote{archive}, \dQuote{inspect}, \dQuote{newbies},
\dQuote{pending}, \dQuote{pretest}, \dQuote{publish}, \dQuote{recheck}, \dQuote{waiting},
\dQuote{BA}, \dQuote{KH}, \dQuote{KL}, \dQuote{UL}, and \dQuote{VW}.}
\usage{
incoming(folder = c("auto", known_folders), check = TRUE, sort = TRUE,
  ping = TRUE)

ciw(folder = c("auto", known_folders), check = TRUE, sort = TRUE,
  ping = TRUE)

known_folders
}
\arguments{
\item{folder}{A character variable correponding to one (or more) of the existing directories
at the \code{incoming} directory at CRAN, or a meta value. The default value is \sQuote{auto}
to designate the combination of \sQuote{pending}, \sQuote{recheck}, \sQuote{inspect} and
\sQuote{pretest}. See also below for \code{known_folders}.}

\item{check}{A logical variable with a default of \sQuote{TRUE} indicating that the value
of \sQuote{folder} should be check against a list of known values. Using \sQuote{FALSE}
allows new values, or different combinations not supported by default.}

\item{sort}{A logical variable with a default of \sQuote{TRUE} indicating that the overall
result be sorted by column \sQuote{Age}.}

\item{ping}{A logical variable with a default of \sQuote{TRUE} indicating that network
connectivity should be checked first.}
}
\value{
A \sQuote{data.table} object with first column \sQuote{folder} as well as columns
for package name, upload time and size.
}
\description{
Summarizes the current state of the incoming queue at CRAN. A shorter alias is provided by
function \code{ciw}.
}
\examples{
incoming()
}
\keyword{datasets}
