% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_sequence.R
\name{filter_seq}
\alias{filter_seq}
\title{Create the filter sequence container}
\usage{
filter_seq(
  context = "visits",
  rules = NULL,
  sequence = "in_order",
  exclude = FALSE,
  exclude_checkpoint = NULL
)
}
\arguments{
\item{context}{Defines the level that the filter logic should operate on. Valid values for sequential filters is visitors and visits. See Details}

\item{rules}{List of rules created using \code{filter_rule()} function. Must wrapped in a list() function.}

\item{sequence}{How should the sequence of items be considered. Options: \code{in_order} (default), \code{before}, \code{after}, \code{and}, \code{or}}

\item{exclude}{Excludes the entire sequence container which will include all rules.}

\item{exclude_checkpoint}{Which checkpoints (rules) should be excluded. Example \code{c(1, 4)}. See Details}
}
\value{
a structured list of containers to be used to build the filter
}
\description{
This function combines rules into a sequence container
}
\details{
\strong{Context}

The rules in a filter have a context that specify the level of operation. The context can be visitors, visits or hits.
As an example, let's build a filter rule where revenue is greater than 0 (meaning a purchase took place) and change the context to see how things change.
If the context is set to visitors, the filter includes all hits from visitors that have a purchase of some kind during a visit. This is useful in analyzing customer behavior in visits leading up to a purchase and possibly behavior after a purchase.
the context is set to visits, the filter includes all hits from visits where a purchase occurred. This is useful for seeing the behavior of a visitor in immediate page views leading up to the purchase.
If the context is set to hit, the filter only includes hits where a purchase occurred, and no other hits. This is useful in seeing which products were most popular.
In the above example, the context for the container listed is hits. This means that the container only evaluates data at the hit level, (in contrast to visit or visitor level). The rows in the container are also at the hit level.

\strong{Exclude checkpoint}

Ensures the next checkpoint doesn't happen between the
preceding checkpoint and the subsequent checkpoint. If there is no subsequent
checkpoint then the excluded checkpoint must not occur at any point after
the preceding checkpoint. If there is no preceding checkpoint then the
excluded checkpoint must not have occurred at any point preceding the
subsequent checkpoint.

\strong{More Information}

Sequential filters can be difficult to get right. Referencing this article
can help: https://experienceleague.adobe.com/docs/analytics-platform/using/cja-components/cja-filters/filters-overview.html?lang=en
}
\examples{
\dontrun{
filter_seq(context = 'visits', rules = list(rule1, rule2),
sequence = 'in_order', exclude = FALSE)}

}
