% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcov.R
\name{stcov}
\alias{stcov}
\title{Population and sample (co)variance}
\usage{
stcov(x, wt = NULL, sample = TRUE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{wt}{a vector with total weights. Default is \code{NULL}.}

\item{sample}{a logical value indicating if the sample variance should be used.
Default is \code{TRUE}. If \code{TRUE}, the unbiased estimate (n-1) is used;
if \code{FALSE}, the maximum likelihood estimate is used.}
}
\value{
a numeric value or a numeric matrix.
}
\description{
Estimates the weighted and unweighted population and sample
covariance for a vector, a matrix or a data frame. Missing values are omitted.
}
\examples{

# Variance ----

## Sample variance with no weights
stcov(x = iris$Sepal.Length, sample = TRUE)

## Population variance with no weights
stcov(x = iris$Sepal.Length, sample = TRUE)

## Sample variance with no weights
wt = c(100, rep(1,nrow(iris)-1)) # Unbalanced weights
stcov(x = iris$Sepal.Length, sample = FALSE, wt = wt)

## Population variance with no weights
wt = c(100, rep(1,nrow(iris)-1)) # Unbalanced weights
stcov(x = iris$Sepal.Length, sample = FALSE)


# Covariance ----

## Sample covariance with no weights
stcov(x = iris[,1:4], sample = TRUE)

## Population covariance with no weights
stcov(x = iris[,1:4], sample = TRUE)

## Sample covariance with no weights
wt = c(100, rep(1,nrow(iris)-1)) # Unbalanced weights
stcov(x = iris[,1:4], sample = FALSE, wt = wt)

## Population covariance with no weights
wt = c(100, rep(1,nrow(iris)-1)) # Unbalanced weights
stcov(x = iris[,1:4], sample = FALSE)



}
\keyword{stats}
