\name{asa_physical_status}
\alias{asa_physical_status}
\title{
ASA Physical Status Classification System
}
\description{
Retrieves the definition and examples for the American Society of Anesthesiologists (ASA) Physical Status Classification System. This system is used to assess the fitness of patients before surgery.
}
\usage{
asa_physical_status(asa_class, emergency = 0)
}
\arguments{
  \item{asa_class}{
Numeric (1-6). The ASA Physical Status Class.
1: Normal healthy patient.
2: Mild systemic disease.
3: Severe systemic disease.
4: Severe systemic disease that is a constant threat to life.
5: Moribund patient not expected to survive without operation.
6: Declared brain-dead patient for organ donation.
}
  \item{emergency}{
Numeric (0 or 1). Is the procedure an emergency? (1 = Yes). Adds the "E" suffix to the classification.
}
}
\value{
A list containing:
\item{Classification}{The formatted classification string (e.g., "ASA III-E").}
\item{Definition}{The official definition of the class.}
\item{Examples}{Common adult clinical examples corresponding to the class.}
\item{Emergency_Status}{Boolean indicating if the procedure is emergent.}
}
\references{
ASA House of Delegates/Executive Committee. ASA Physical Status Classification System. American Society of Anesthesiologists. Last amended 2020.
}
\examples{

# Example 1: Healthy Patient
asa_physical_status(1, 0)

# Example 2: Emergency Surgery for High Risk Patient
# ASA IV (Severe systemic disease, threat to life)
asa_physical_status(4, 1)
}
