\name{bisap_score}
\alias{bisap_score}
\title{
BISAP Score for Pancreatitis Mortality
}
\description{
Calculates the BISAP (Bedside Index for Severity in Acute Pancreatitis) score to estimate in-hospital mortality risk. This simple 5-point scoring system uses data available within the first 24 hours of admission.
}
\usage{
bisap_score(bun, impaired_mental_status, sirs_criteria_met, age,
            pleural_effusion, bun_units = "mg/dL")
}
\arguments{
  \item{bun}{
Numeric. Blood Urea Nitrogen level. (> 25 mg/dL adds +1 point).
}
  \item{impaired_mental_status}{
Numeric (0 or 1). Evidence of impaired mental status (Glasgow Coma Scale < 15). (1 = Yes, +1 point).
}
  \item{sirs_criteria_met}{
Numeric (0 or 1). Does the patient meet >= 2 SIRS criteria? (1 = Yes, +1 point).
}
  \item{age}{
Numeric. Patient age in years. (> 60 years adds +1 point).
}
  \item{pleural_effusion}{
Numeric (0 or 1). Presence of pleural effusion on imaging. (1 = Yes, +1 point).
}
  \item{bun_units}{
String. Units for BUN. "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{BISAP_Score}{The calculated score (Range 0-5).}
\item{Mortality_Risk}{Risk stratification (Low vs. High).}
}
\references{
Wu BU, Johannes RS, Sun X, Tabak Y, Conwell DL, Banks PA. The early prediction of mortality in acute pancreatitis: a large population-based study. Gut. 2008;57(12):1698-1703. doi:10.1136/gut.2008.152702
}
\examples{

# Example 1: High Risk
# BUN 30 (+1), Altered mental status (+1), SIRS (+1), Age 65 (+1), No effusion
# Score = 4
bisap_score(30, 1, 1, 65, 0)

# Example 2: Low Risk
# BUN 15 (0), Normal mental status (0), No SIRS (0), Age 40 (0), No effusion (0)
# Score = 0
bisap_score(15, 0, 0, 40, 0)
}
