\name{cdai_rheumatoid_arthritis}
\alias{cdai_rheumatoid_arthritis}
\title{
Clinical Disease Activity Index (CDAI) for Rheumatoid Arthritis
}
\description{
Calculates the CDAI score to assess disease activity in patients with Rheumatoid Arthritis. Unlike the DAS28, the CDAI does not require laboratory results (ESR or CRP), allowing for immediate calculation during a clinical visit. It is the simple sum of the tender joint count (28 joints), swollen joint count (28 joints), and patient and provider global assessments (0-10 scale).
}
\usage{
cdai_rheumatoid_arthritis(tender_joint_count, swollen_joint_count,
                          patient_global_assessment, provider_global_assessment)
}
\arguments{
  \item{tender_joint_count}{
Numeric (0-28). Number of tender joints upon examination.
}
  \item{swollen_joint_count}{
Numeric (0-28). Number of swollen joints upon examination.
}
  \item{patient_global_assessment}{
Numeric (0-10). Patient's Global Assessment of disease activity on a visual analog scale (0 = best, 10 = worst).
}
  \item{provider_global_assessment}{
Numeric (0-10). Provider's Global Assessment of disease activity on a visual analog scale (0 = best, 10 = worst).
}
}
\value{
A list containing:
\item{CDAI_Score}{The calculated score (Range 0-76).}
\item{Disease_Activity}{Classification based on the score: Remission (<= 2.8), Low (> 2.8 - 10.0), Moderate (> 10.0 - 22.0), High (> 22.0).}
}
\references{
Aletaha D, Smolen J. The Simplified Disease Activity Index (SDAI) and the Clinical Disease Activity Index (CDAI): a review of their usefulness and validity in rheumatoid arthritis. Clin Exp Rheumatol. 2005;23(5 Suppl 39):S100-8.
}
\examples{

# Example 1: High Activity
# 8 tender, 6 swollen, Pt Global 7, Prov Global 6
# Score = 8 + 6 + 7 + 6 = 27
cdai_rheumatoid_arthritis(8, 6, 7, 6)

# Example 2: Remission
# 0 tender, 0 swollen, Pt Global 1, Prov Global 0.5
# Score = 1.5
cdai_rheumatoid_arthritis(0, 0, 1, 0.5)
}
