\name{cockcroft_gault_crcl}
\alias{cockcroft_gault_crcl}
\title{
Creatinine Clearance (Cockcroft-Gault Equation)
}
\description{
Calculates Creatinine Clearance (CrCl) using the Cockcroft-Gault equation. This implementation replicates the MDCalc logic for weight selection:
- BMI < 18.5: Uses Actual Body Weight.
- BMI 18.5 - 24.9: Uses Ideal Body Weight.
- BMI >= 25: Uses Adjusted Body Weight.
If height is not provided, it defaults to using Actual Body Weight.
}
\usage{
cockcroft_gault_crcl(sex, age, creatinine, weight_kg, height_cm = NULL,
                     creatinine_units = "mg/dL")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years.
}
  \item{creatinine}{
Numeric. Serum creatinine level.
}
  \item{weight_kg}{
Numeric. Actual body weight in kilograms.
}
  \item{height_cm}{
Numeric (Optional). Height in centimeters. Required to calculate BMI/IBW for the specific weight selection logic.
}
  \item{creatinine_units}{
String. Units for creatinine. Options: "mg/dL" (default) or "micromol/L".
}
}
\value{
A list containing:
\item{CrCl_mL_min}{The estimated Creatinine Clearance.}
\item{Weight_Used_kg}{The specific weight value used in the calculation.}
\item{Method}{Description of which weight formula was selected (Actual, Ideal, or Adjusted).}
}
\references{
Cockcroft DW, Gault MH. Prediction of creatinine clearance from serum creatinine. Nephron. 1976;16(1):31-41. doi:10.1159/000180580
Winter MA, Guhr KN, Berg GM. Impact of various body weights and serum creatinine concentrations on the bias and accuracy of the Cockcroft-Gault equation. Pharmacotherapy. 2012;32(7):604-612.
}
\examples{

# Example 1: Normal Weight Male
# Age 54, Cr 1.2, Wt 75kg, Ht 180cm (BMI ~23 -> Uses IBW)
cockcroft_gault_crcl("male", 54, 1.2, 75, 180)

# Example 2: Obese Female
# Age 65, Cr 0.9, Wt 90kg, Ht 160cm (BMI ~35 -> Uses Adjusted BW)
cockcroft_gault_crcl("female", 65, 0.9, 90, 160)

# Example 3: No Height Provided (Defaults to Actual Weight)
cockcroft_gault_crcl("male", 40, 1.0, 80)
}
