\name{dsm5_major_depressive_disorder}
\alias{dsm5_major_depressive_disorder}
\title{
DSM-5 Criteria for Major Depressive Disorder
}
\description{
Evaluates the DSM-5 diagnostic criteria for Major Depressive Disorder (MDD). A diagnosis requires five or more symptoms present during the same 2-week period and representing a change from previous functioning. At least one of the symptoms must be either (1) depressed mood or (2) loss of interest or pleasure.
}
\usage{
dsm5_major_depressive_disorder(depressed_mood, diminished_interest,
                               weight_change, sleep_disturbance,
                               psychomotor_change, fatigue, worthlessness_guilt,
                               diminished_concentration, suicidal_ideation)
}
\arguments{
  \item{depressed_mood}{
Numeric (0 or 1). Depressed mood most of the day, nearly every day. (1 = Yes).
}
  \item{diminished_interest}{
Numeric (0 or 1). Markedly diminished interest or pleasure in all, or almost all, activities. (1 = Yes).
}
  \item{weight_change}{
Numeric (0 or 1). Significant weight loss/gain or decrease/increase in appetite. (1 = Yes).
}
  \item{sleep_disturbance}{
Numeric (0 or 1). Insomnia or hypersomnia. (1 = Yes).
}
  \item{psychomotor_change}{
Numeric (0 or 1). Psychomotor agitation or retardation (observable by others). (1 = Yes).
}
  \item{fatigue}{
Numeric (0 or 1). Fatigue or loss of energy. (1 = Yes).
}
  \item{worthlessness_guilt}{
Numeric (0 or 1). Feelings of worthlessness or excessive/inappropriate guilt. (1 = Yes).
}
  \item{diminished_concentration}{
Numeric (0 or 1). Diminished ability to think or concentrate, or indecisiveness. (1 = Yes).
}
  \item{suicidal_ideation}{
Numeric (0 or 1). Recurrent thoughts of death, recurrent suicidal ideation without a specific plan, or a suicide attempt/plan. (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met" or "Criteria Not Met".}
\item{Symptom_Count}{Total number of symptoms reported.}
\item{Criteria_Check}{Verification of the core symptom requirement and total count threshold.}
}
\references{
American Psychiatric Association. Diagnostic and Statistical Manual of Mental Disorders. 5th ed. Arlington, VA: American Psychiatric Association; 2013.
}
\examples{

# Example 1: Diagnosis Confirmed
# Depressed mood, loss of interest, sleep issues, fatigue,
#concentration issues (5 symptoms, core present)
dsm5_major_depressive_disorder(1, 1, 0, 1, 0, 1, 0, 1, 0)

# Example 2: Criteria Not Met
# 4 symptoms only, despite core symptom being present
dsm5_major_depressive_disorder(1, 0, 1, 1, 0, 1, 0, 0, 0)
}
