\name{edacs_chest_pain_score}
\alias{edacs_chest_pain_score}
\title{
Emergency Department Assessment of Chest Pain Score (EDACS)
}
\description{
Calculates the EDACS Score to identify chest pain patients with a low risk of Major Adverse Cardiac Events (MACE) who may be safe for early discharge. The full EDACS-ADP (Accelerated Diagnostic Protocol) incorporates the score (< 16), lack of new ischemia on EKG, and negative troponin measurements at 0 and 2 hours.
}
\usage{
edacs_chest_pain_score(age, sex, known_cad_or_3_risk_factors, diaphoresis,
                       radiation, pain_inspiration, pain_palpation,
                       ekg_ischemia_present = FALSE, troponin_normal = TRUE)
}
\arguments{
  \item{age}{
Numeric. Patient age in years (must be >= 18).
}
  \item{sex}{
String. Patient sex ("Male" or "Female"). Male sex adds +6 points.
}
  \item{known_cad_or_3_risk_factors}{
Numeric (0 or 1). Does the patient have known Coronary Artery Disease (CAD) OR >= 3 risk factors (Age 45-65M/55-65F, Dyslipidemia, Diabetes, Hypertension, Current Smoker, Family History)? (1 = Yes, +4 points).
}
  \item{diaphoresis}{
Numeric (0 or 1). Presence of diaphoresis. (1 = Yes, +3 points).
}
  \item{radiation}{
Numeric (0 or 1). Pain radiates to arm, shoulder, neck, or jaw. (1 = Yes, +5 points).
}
  \item{pain_inspiration}{
Numeric (0 or 1). Pain occurs or worsens with inspiration. (1 = Yes, -4 points).
}
  \item{pain_palpation}{
Numeric (0 or 1). Pain is reproduced by palpation. (1 = Yes, -6 points).
}
  \item{ekg_ischemia_present}{
Numeric (0 or 1). New ischemia on ECG. (1 = Yes). Required for full protocol assessment.
}
  \item{troponin_normal}{
Numeric (0 or 1). Are 0h and 2h troponin levels negative? (1 = Yes). Required for full protocol assessment.
}
}
\value{
A list containing:
\item{EDACS_Score}{The calculated score (Range -10 to +50 range possible depending on inputs).}
\item{Risk_Category}{"Low Risk" if Score < 16 AND no EKG ischemia AND normal troponins; otherwise "Not Low Risk".}
\item{Recommendation}{Guidance on discharge vs. observation.}
}
\references{
Than M, Flaws D, Sanders S, et al. Development and validation of the Emergency Department Assessment of Chest pain Score and 2h accelerated diagnostic protocol. Emerg Med Australas. 2014;26(1):34-44. doi:10.1111/1742-6723.12164
}
\examples{

# Example 1: Low Risk Patient
# 40yo Female (2), No Hx (0), No Diaphoresis (0), No Radiation (0),
# Pain with Inspiration (-4), Palpation (-6) -> Score = -8
# Normal EKG, Normal Troponin
edacs_chest_pain_score(40, "female", 0, 0, 0, 1, 1, 0, 1)

# Example 2: High Risk Patient
# 65yo Male (10+6=16), Known CAD (+4), Diaphoresis (+3) -> Score = 23
edacs_chest_pain_score(65, "male", 1, 1, 0, 0, 0, 0, 1)
}
