\name{eutos_cml_score}
\alias{eutos_cml_score}
\title{
EUTOS Score for Chronic Myelogenous Leukemia (CML)
}
\description{
Calculates the EUTOS (European Treatment and Outcome Study) score to predict the likelihood of achieving Complete Cytogenetic Response (CCyR) at 18 months in newly diagnosed CML patients treated with Tyrosine Kinase Inhibitors (TKIs). The score uses the percentage of basophils in peripheral blood and spleen size measured below the costal margin.
}
\usage{
eutos_cml_score(basophils_percent, spleen_size_cm)
}
\arguments{
  \item{basophils_percent}{
Numeric. Percentage of basophils in peripheral blood.
}
  \item{spleen_size_cm}{
Numeric. Spleen size measured as the maximum distance palpable below the costal margin in centimeters.
}
}
\value{
A list containing:
\item{EUTOS_Score}{The calculated prognostic score.}
\item{Risk_Category}{"Low Risk" (Score <= 87) or "High Risk" (Score > 87).}
}
\references{
Hasford J, Baccarani M, Hoffmann V, et al. Predicting complete cytogenetic response and subsequent progression-free survival in 2060 patients with CML on imatinib treatment: the EUTOS score. Blood. 2011;118(3):686-692. doi:10.1182/blood-2010-12-325548
}
\examples{

# Example 1: Low Risk
# Basophils 2\%, Spleen 0 cm
# Score = (7*2) + (4*0) = 14
eutos_cml_score(2, 0)

# Example 2: High Risk
# Basophils 8\%, Spleen 10 cm
# Score = (7*8) + (4*10) = 56 + 40 = 96
eutos_cml_score(8, 10)
}
