\name{g8_geriatric_screen}
\alias{g8_geriatric_screen}
\title{
G8 Geriatric Screening Tool
}
\description{
Calculates the G8 score, a screening tool developed to identify elderly cancer patients who would benefit from a Comprehensive Geriatric Assessment (CGA). The score consists of 7 items from the Mini Nutritional Assessment (MNA) and patient age. A score of 14 or lower indicates vulnerability or frailty.
}
\usage{
g8_geriatric_screen(food_intake, weight_loss, mobility, neuropsychological,
                    bmi_score, more_than_3_meds, self_rated_health, age)
}
\arguments{
  \item{food_intake}{
Numeric (0-2). Has food intake declined over the past 3 months?
0: Severe decrease in food intake.
1: Moderate decrease in food intake.
2: No decrease in food intake.
}
  \item{weight_loss}{
Numeric (0-3). Weight loss during the last 3 months.
0: Weight loss > 3 kg.
1: Does not know.
2: Weight loss between 1 and 3 kg.
3: No weight loss.
}
  \item{mobility}{
Numeric (0-2). Mobility status.
0: Bed or chair bound.
1: Able to get out of bed/chair but does not go out.
2: Goes out.
}
  \item{neuropsychological}{
Numeric (0-2). Neuropsychological problems.
0: Severe dementia or depression.
1: Mild dementia.
2: No psychological problems.
}
  \item{bmi_score}{
Numeric (0-3). Body Mass Index (BMI).
0: BMI < 19.
1: BMI 19 - <21.
2: BMI 21 - <23.
3: BMI >= 23.
}
  \item{more_than_3_meds}{
Numeric (0 or 1). Takes more than 3 prescription drugs per day. (1 = Yes, 0 = No). Note: "No" adds 1 point to the score.
}
  \item{self_rated_health}{
Numeric (0, 0.5, 1, 2). In comparison with other people of the same age, how does the patient consider their health status?
0: Not as good.
0.5: Does not know.
1: As good.
2: Better.
}
  \item{age}{
Numeric. Patient age in years.
< 80: 2 points.
80-85: 1 point.
> 85: 0 points.
}
}
\value{
A list containing:
\item{G8_Score}{The calculated total score (Range 0-17).}
\item{Interpretation}{Clinical recommendation regarding the need for full geriatric assessment.}
}
\references{
Bellera CA, Rainfray M, Mathoulin-Pélissier S, et al. Screening older cancer patients: first evaluation of the G-8 geriatric screening tool. Ann Oncol. 2012;23(8):2166-2172. doi:10.1093/annonc/mdr587
}
\examples{

# Example 1: Frail Patient
# Severe food decline (0), Wt loss >3kg (0), Bed bound (0), Dementia (0),
# BMI <19 (0), Polypharmacy (1), Poor health (0), Age 86 (0)
# Score = 0
g8_geriatric_screen(0, 0, 0, 0, 0, 1, 0, 86)

# Example 2: Fit Patient
# No decline (2), No wt loss (3), Goes out (2), No neuro (2),
# BMI >23 (3), No polypharmacy (0), Better health (2), Age 75 (2)
# Score = 2+3+2+2+3+1+2+2 = 17
g8_geriatric_screen(2, 3, 2, 2, 3, 0, 2, 75)
}
