\name{ganzoni_iron_deficit}
\alias{ganzoni_iron_deficit}
\title{
Ganzoni Equation for Iron Deficiency Anemia
}
\description{
Calculates the total body iron deficit in milligrams using the Ganzoni equation. This value determines the total dose of parenteral iron required for complete repletion in patients with iron deficiency anemia.
}
\usage{
ganzoni_iron_deficit(weight_kg, actual_hb, target_hb = 13, iron_stores_mg = 500)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient body weight in kilograms.
}
  \item{actual_hb}{
Numeric. Patient's current hemoglobin level in g/dL.
}
  \item{target_hb}{
Numeric. Target hemoglobin level in g/dL. Defaults to 13 g/dL (commonly used standard), but can be adjusted based on patient age, sex, or population.
}
  \item{iron_stores_mg}{
Numeric. Estimated iron stores in milligrams. Defaults to 500 mg (standard for adults). For children or smaller individuals, a lower value (e.g., 15 mg/kg if weight < 35 kg) might be appropriate.
}
}
\details{
The formula is:
\deqn{Total Iron Deficit (mg) = [Weight (kg) \times (Target Hb - Actual Hb) (g/dL) \times 2.4] + Iron Stores (mg)}
}
\value{
A list containing:
\item{Total_Iron_Deficit_mg}{The calculated total iron deficit in milligrams.}
\item{Formula}{A string representation of the calculation performed.}
}
\references{
Ganzoni AM. Intravenous iron-dextran: therapeutic and experimental possibilities. Schweiz Med Wochenschr. 1970;100(7):301-303.
}
\examples{

# Example 1: Standard Adult
# 70 kg, Hb 8 g/dL, Target 13 g/dL, Stores 500 mg
# Deficit = (70 * 5 * 2.4) + 500 = 840 + 500 = 1340 mg
ganzoni_iron_deficit(70, 8)

# Example 2: Customized Target and Stores
# 50 kg, Hb 10 g/dL, Target 12 g/dL, Stores 0 mg (Conservative)
# Deficit = (50 * 2 * 2.4) + 0 = 240 mg
ganzoni_iron_deficit(50, 10, target_hb = 12, iron_stores_mg = 0)
}
