\name{los_angeles_esophagitis_grade}
\alias{los_angeles_esophagitis_grade}
\title{
Los Angeles (LA) Grading of Esophagitis
}
\description{
Retrieves the definition for the Los Angeles (LA) Classification system for grading the severity of reflux esophagitis. This widely accepted endoscopic grading system stratifies esophagitis into four grades (A through D) based on the extent of mucosal breaks.
}
\usage{
los_angeles_esophagitis_grade(grade)
}
\arguments{
  \item{grade}{
String. The LA Grade observed. Options: "grade_a", "grade_b", "grade_c", "grade_d".
}
}
\value{
A list containing:
\item{LA_Grade}{The formatted grade string (e.g., "Grade A").}
\item{Definition}{The detailed endoscopic description of the grade.}
}
\references{
Lundell LR, Dent J, Bennett JR, et al. Endoscopic assessment of oesophagitis: clinical and functional correlates and further validation of the Los Angeles classification. Gut. 1999;45(2):172-180. doi:10.1136/gut.45.2.172
}
\examples{

# Example 1: Mild Esophagitis
los_angeles_esophagitis_grade("grade_a")

# Example 2: Severe Esophagitis (Circumferential)
los_angeles_esophagitis_grade("grade_d")
}
