\name{news2_score}
\alias{news2_score}
\title{
National Early Warning Score 2 (NEWS2)
}
\description{
Calculates the NEWS2 score, an updated track-and-trigger system for acute illness severity. NEWS2 includes two SpO2 scales: Scale 1 for standard patients and Scale 2 for patients with hypercapnic respiratory failure (e.g., COPD) who have a target saturation of 88-92\%. It also accounts for new confusion in the consciousness assessment (ACVPU).
}
\usage{
news2_score(respiratory_rate, oxygen_saturation, supplemental_oxygen,
            systolic_bp, heart_rate, consciousness, temperature,
            hypercapnic_respiratory_failure = FALSE)
}
\arguments{
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation percentage (SpO2).
}
  \item{supplemental_oxygen}{
Numeric (0 or 1). Is the patient receiving supplemental oxygen? (1 = Yes, +2 points).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{consciousness}{
String. Level of consciousness: "alert", "confusion", "voice", "pain", "unresponsive". Any status other than "alert" scores 3 points.
}
  \item{temperature}{
Numeric. Body temperature in degrees Celsius.
}
  \item{hypercapnic_respiratory_failure}{
Numeric or Logical (0/1 or FALSE/TRUE). Does the patient have confirmed hypercapnic respiratory failure (e.g., COPD) requiring a target SpO2 of 88-92\%? If TRUE, SpO2 points are calculated using Scale 2.
}
}
\value{
A list containing:
\item{NEWS2_Score}{The calculated total score (Range 0-20).}
\item{Clinical_Risk}{Risk classification (Low, Low-Medium, Medium, High).}
\item{Response_Urgency}{Recommended clinical response level.}
}
\references{
Royal College of Physicians. National Early Warning Score (NEWS) 2: Standardising the assessment of acute-illness severity in the NHS. Updated report of a working party. London: RCP, 2017.
}
\examples{

# Example 1: COPD Patient (Scale 2)
# RR 22 (+2), SpO2 90% (0 on Scale 2), On O2 (+2), SBP 130, HR 80, Alert, Temp 37
# Score = 4
news2_score(22, 90, 1, 130, 80, "alert", 37.0, hypercapnic_respiratory_failure = TRUE)

# Example 2: Standard Patient (Scale 1)
# RR 12, SpO2 93% (+2), No O2, SBP 100 (+2), HR 115 (+2), New Confusion (+3), Temp 38.5 (+1)
# Score = 10
news2_score(12, 93, 0, 100, 115, "confusion", 38.5)
}
