\name{prague_cm_classification}
\alias{prague_cm_classification}
\title{
Prague C & M Criteria for Barrett's Esophagus
}
\description{
Calculates the Prague C & M classification for characterizing the extent of Barrett's Esophagus. It uses endoscopic measurements (distance from incisors) to determine the circumferential (C) and maximum (M) extent of metaplasia relative to the gastroesophageal junction (GEJ).
}
\usage{
prague_cm_classification(ge_junction_distance_cm,
                         circumferential_metaplasia_proximal_cm,
                         max_metaplasia_proximal_cm)
}
\arguments{
  \item{ge_junction_distance_cm}{
Numeric. Distance from the incisors to the gastroesophageal junction (GEJ) in centimeters.
}
  \item{circumferential_metaplasia_proximal_cm}{
Numeric. Distance from the incisors to the proximal margin of the circumferential metaplasia in centimeters.
}
  \item{max_metaplasia_proximal_cm}{
Numeric. Distance from the incisors to the proximal margin of the maximum extent of metaplasia (tongues/islands) in centimeters.
}
}
\value{
A list containing:
\item{Prague_Classification}{The formatted classification string (e.g., "C2M5").}
\item{C_Length_cm}{The calculated length of the circumferential segment.}
\item{M_Length_cm}{The calculated maximum length of the metaplastic segment.}
}
\references{
Sharma P, Dent J, Armstrong D, et al. The Development and Validation of an Endoscopic Grading System for Barrett's Esophagus: The Prague C & M Criteria. Gastroenterology. 2006;131(5):1392-1399. doi:10.1053/j.gastro.2006.08.032
}
\examples{

# Example 1: Long segment
# GEJ at 40cm, Circumferential at 37cm, Max tongue at 32cm
# C = 40-37 = 3, M = 40-32 = 8 -> C3M8
prague_cm_classification(40, 37, 32)

# Example 2: Short segment (No circumferential)
# GEJ at 38cm, Circumferential at 38cm (none), Max tongue at 36cm
# C = 0, M = 2 -> C0M2
prague_cm_classification(38, 38, 36)
}
