\name{prostate_tumor_volume_density}
\alias{prostate_tumor_volume_density}
\title{
Prostate Tumor Volume and PSA Density Calculator
}
\description{
Calculates the estimated prostate volume using the ellipsoid formula (Length x Width x Height x 0.52) and the PSA density (PSA / Prostate Volume). These metrics are useful in the evaluation of prostate cancer risk, particularly in distinguishing between benign prostatic hyperplasia (BPH) and prostate cancer.
}
\usage{
prostate_tumor_volume_density(prostate_length_cm, prostate_width_cm,
                              prostate_height_cm, psa_ng_ml)
}
\arguments{
  \item{prostate_length_cm}{
Numeric. Length of the prostate in centimeters (measured via ultrasound or MRI).
}
  \item{prostate_width_cm}{
Numeric. Width of the prostate in centimeters.
}
  \item{prostate_height_cm}{
Numeric. Height of the prostate in centimeters.
}
  \item{psa_ng_ml}{
Numeric. Serum Prostate Specific Antigen (PSA) level in ng/mL.
}
}
\value{
A list containing:
\item{Prostate_Volume_cc}{The estimated prostate volume in cubic centimeters (cc) or milliliters (mL).}
\item{PSA_Density_ng_ml_cc}{The calculated PSA density. Values > 0.15 ng/mL/cc are often considered more suspicious for prostate cancer.}
}
\references{
Terris MK, Stamey TA. Determination of prostate volume by transrectal ultrasound. J Urol. 1991;145(5):984-987. doi:10.1016/s0022-5347(17)38508-7
}
\examples{

# Example 1: High Density (Suspicious)
# Prostate 4x4x3 cm, PSA 10
# Vol = 0.52 * 4 * 4 * 3 = 24.96 cc
# Density = 10 / 24.96 = 0.40
prostate_tumor_volume_density(4, 4, 3, 10)

# Example 2: Low Density (Likely BPH)
# Prostate 5x6x5 cm, PSA 4
# Vol = 0.52 * 5 * 6 * 5 = 78 cc
# Density = 4 / 78 = 0.05
prostate_tumor_volume_density(5, 6, 5, 4)
}
