\name{rads_smoke_inhalation_score}
\alias{rads_smoke_inhalation_score}
\title{
RADS (Radiologists Score) for Smoke Inhalation Injury
}
\description{
Calculates the RADS score to stratify the severity of smoke inhalation injury based on chest CT findings. The chest CT slice is divided into four quadrants, and each quadrant is scored based on the worst finding present. The total score for the slice ranges from 0 to 12. High scores (>8) are associated with a significantly increased risk of pneumonia, ARDS, and death.
}
\usage{
rads_smoke_inhalation_score(quadrant1_finding, quadrant2_finding,
                            quadrant3_finding, quadrant4_finding)
}
\arguments{
  \item{quadrant1_finding}{
String. Finding in the 1st quadrant. Options: "normal" (0 pts), "interstitial" (Increased interstitial markings, 1 pt), "ground_glass" (Ground glass opacification, 2 pts), "consolidation" (3 pts).
}
  \item{quadrant2_finding}{
String. Finding in the 2nd quadrant. Options: "normal", "interstitial", "ground_glass", "consolidation".
}
  \item{quadrant3_finding}{
String. Finding in the 3rd quadrant. Options: "normal", "interstitial", "ground_glass", "consolidation".
}
  \item{quadrant4_finding}{
String. Finding in the 4th quadrant. Options: "normal", "interstitial", "ground_glass", "consolidation".
}
}
\value{
A list containing:
\item{RADS_Score}{The calculated total score (Range 0-12).}
\item{Risk_Category}{Interpretation ("Lower Risk" <= 8, "High Risk" > 8).}
}
\references{
Yamamura H, Kaga S, Kaneda K, et al. Chest computed tomography performed on admission helps predict the severity of smoke-inhalation injury. Crit Care. 2013;17(3):R95. doi:10.1186/cc12740
}
\examples{

# Example 1: Severe Injury
# Consolidation in all quadrants
rads_smoke_inhalation_score("consolidation", "consolidation", "consolidation", "consolidation")

# Example 2: Mild/Moderate Injury
# Interstitial markings in 2 quadrants, Ground glass in 2
rads_smoke_inhalation_score("interstitial", "interstitial", "ground_glass", "ground_glass")
}
