\name{salivary_gland_cancer_port_survival}
\alias{salivary_gland_cancer_port_survival}
\title{
Salivary Gland Cancer Model for Survival +/- Postoperative Radiotherapy (PORT)
}
\description{
Provides a structure to calculate overall survival probability for patients with resected major salivary gland cancer, with or without postoperative radiotherapy (PORT). This model is based on the study by Jacobs et al. using the National Cancer Database (NCDB). It helps in decision-making regarding the benefit of PORT by stratifying survival based on clinical and pathological factors.
}
\usage{
salivary_gland_cancer_port_survival(age_at_diagnosis, sex, charlson_deyo_score,
                                    pathologic_t_stage, ratio_nodal_positivity,
                                    grade, surgical_margin, primary_site,
                                    port_received)
}
\arguments{
  \item{age_at_diagnosis}{
Numeric. Patient age in years.
}
  \item{sex}{
String. "Male" or "Female".
}
  \item{charlson_deyo_score}{
Numeric. Charlson-Deyo comorbidity score (0, 1, 2, or >=3).
}
  \item{pathologic_t_stage}{
Numeric. AJCC Pathologic T Stage (1, 2, 3, or 4).
}
  \item{ratio_nodal_positivity}{
String. Ratio of positive lymph nodes to total nodes examined. Options: "0", "0.1-10", "10.1-49.9", ">=50".
}
  \item{grade}{
String. Tumor grade. Options: "low", "intermediate", "high".
}
  \item{surgical_margin}{
String. Status of surgical margins. Options: "negative", "positive".
}
  \item{primary_site}{
String. Primary tumor site. Options: "parotid", "submandibular", "sublingual".
}
  \item{port_received}{
String. Did the patient receive Postoperative Radiotherapy? "no", "yes".
}
}
\value{
A list containing:
\item{Note}{Information regarding the calculation logic.}
\item{Inputs}{The validated inputs provided for the model.}
}
\references{
Jacobs CD, et al. Nomogram to Predict Survival Benefit of Postoperative Radiotherapy for Major Salivary Gland Cancers. Head Neck. 2020.
}
\examples{
# Example: 65yo Male with T3N1 Parotid Cancer, Positive Margins
salivary_gland_cancer_port_survival(65, "male", 0, 3, "0.1-10", "high", "positive", "parotid", "no")
}
