\name{sulf_fast_score}
\alias{sulf_fast_score}
\title{
SULF-FAST Penicillin Allergy Decision Rule
}
\description{
Calculates the SULF-FAST score to stratify the risk of a true Trimethoprim-Sulfamethoxazole (TMP-SMX) allergy. The score helps identify patients who may be candidates for direct oral challenge versus those requiring further evaluation.
}
\usage{
sulf_fast_score(reaction_lt_5_years, anaphylaxis_or_angioedema,
                severe_cutaneous_adverse_reaction, organ_involvement)
}
\arguments{
  \item{reaction_lt_5_years}{
Numeric (0 or 1). Did the reaction occur less than 5 years ago? (1 = Yes, +2 points).
}
  \item{anaphylaxis_or_angioedema}{
Numeric (0 or 1). Did the reaction involve anaphylaxis or angioedema? (1 = Yes, +2 points).
}
  \item{severe_cutaneous_adverse_reaction}{
Numeric (0 or 1). Is there a history of Severe Cutaneous Adverse Reaction (SCAR) such as SJS, TEN, or DRESS? (1 = Yes, +1 point).
}
  \item{organ_involvement}{
Numeric (0 or 1). Did the reaction involve internal organs (e.g., hepatitis, nephritis, pneumonitis, cytopenias)? (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{SULF_FAST_Score}{The calculated total score (Range 0-7).}
\item{Risk_Category}{Risk stratification (Low Risk <= 2, High Risk >= 3).}
\item{Recommendation}{Clinical guidance regarding oral challenge.}
}
\references{
Trubiano JA, et al. The SULF-FAST antibiotic allergy clinical decision rule. J Allergy Clin Immunol Pract. 2023.
}
\examples{

# Example 1: Low Risk
# Reaction > 5 years ago (0), No anaphylaxis (0), No SCAR (0), No organ involvement (0)
# Score = 0
sulf_fast_score(0, 0, 0, 0)

# Example 2: High Risk
# Reaction < 5 years (2), Anaphylaxis (2)
# Score = 4
sulf_fast_score(1, 1, 0, 0)
}
