% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{cloudml_deploy}
\alias{cloudml_deploy}
\title{Deploy SavedModel to CloudML}
\usage{
cloudml_deploy(
  export_dir_base,
  name,
  version = paste0(name, "_1"),
  region = NULL,
  config = NULL
)
}
\arguments{
\item{export_dir_base}{A string containing a directory containing an
exported SavedModels. Consider using \code{\link[tensorflow:export_savedmodel]{tensorflow::export_savedmodel()}}
to export this SavedModel.}

\item{name}{The name for this model (required)}

\item{version}{The version for this model. Versions start with a letter and
contain only letters, numbers and underscores. Defaults to name_1}

\item{region}{The region to be used to deploy this model.}

\item{config}{A list, \code{YAML} or \code{JSON} configuration file as described
\url{https://cloud.google.com/vertex-ai}.}
}
\description{
Deploys a SavedModel to CloudML model for online predictions.
}
\seealso{
\code{\link[=cloudml_predict]{cloudml_predict()}}

Other CloudML functions: 
\code{\link{cloudml_predict}()},
\code{\link{cloudml_train}()}
}
\concept{CloudML functions}
