% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions.R
\name{apply_subgraphs}
\alias{apply_subgraphs}
\title{Applies function to each subgraph of a graph}
\usage{
apply_subgraphs(g, com, f, ...)
}
\arguments{
\item{g}{igraph graph}

\item{com}{vector of memberships that determines the subgraphs (i.e. all elements
with the same label will form a subgraph).}

\item{f}{Function to apply. Takes a graph as input and returns a scalar.}
}
\value{
vector with the result of each subgraph
}
\description{
Applies function to each subgraph of a graph
}
\examples{
data(karate, package="igraphdata")
apply_subgraphs(g=karate, com=V(karate)$Faction, f=gorder)
}
\keyword{internal}
