#' Data from Fairclough (2017). Fitness, fatness and the reallocation of time between children's daily movement behaviours: an analysis of compositional data
#'
#' A dataset containing z_bmi (outcome), time-use compositions (sl,sb,lpa,mvpa), and covariates
#'  from the Fairclough (2017) paper. The data can be found in supp file 7 of the paper
#'  at https://link.springer.com/article/10.1186/s12966-017-0521-z.
#'
#'  The variables in the data are as follows:
#'
#' \itemize{
#'   \item  child_id
#'   \item  school
#'   \item  sex
#'   \item  decimal_age
#'   \item  imd_decile
#'   \item  height mass
#'   \item  bmi
#'   \item  z_bmi
#'   \item  itof_grade
#'   \item  waist_circ
#'   \item  whtr
#'   \item  shuttles_20m
#'   \item  wear_time
#'   \item  sed
#'   \item  lpa
#'   \item  mpa
#'   \item  vpa
#'   \item  mvpa
#'   \item  sleep
#'   \item  min_in_day
#' }
#'
#' @docType data
#' @keywords datasets
#' @name fairclough
#' @usage data(fairclough)
#' @format A data frame with 169 rows and 21 variables
#' @references Fairclough, Stuart J. and Dumuid, Dorothea and Taylor, Sarah and Curry, Whitney and McGrane, Bronagh and Stratton, Gareth and Maher, Carol and Olds, Timothy. Fitness, fatness and the reallocation of time between children’s daily movement behaviours: an analysis of compositional data. International Journal of Behavioral Nutrition and Physical Activity, 2017. 14(1): 64.
NULL
