% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{code}
\alias{code}
\title{Code vector}
\usage{
code(x, codelist, ...)
}
\arguments{
\item{x}{vector to convert to code vector}

\item{codelist}{code list to associate with the values in \code{x}. This
should be convertable to \code{\link{codelist}} using
\code{\link{as.codelist}}.}

\item{...}{Ignored; used to pass extra arguments to other methods}
}
\value{
Returns an object of type 'code'. Except when \code{x} is a factor, \code{x}
keeps classes and attributes assiated with \code{x}. This object is a copy of
\code{x} with a \code{codelist} attribute added. 

When \code{x} is a factor \code{x} it converted to an integer vector. The
labels are the levels of the factor.
}
\description{
A code vector is a vector with an associated code list. The values in the
vector should come from this code list. The values also have an associated
label and optionally additional properties such as a description. See
\code{\link{codelist}} for more information on what should and could be in a
code list.
}
\details{
When \code{codelist} is omitted when case \code{x} is a factor, a code list is
generated from the factor values.
}
\examples{

x <- code(c(1,4,2), codelist(codes = 1:4, labels = letters[1:4]))
print(x)
labels(x)

x <- code(factor(letters[1:3]))
print(x)
attr(x, "codelist")

}
