% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{lambda_diff}
\alias{lambda_diff}
\title{Calculate lambdas for two competing hypotheses}
\usage{
lambda_diff(lambda_preferred, lambda_competing, labels = NULL)
}
\arguments{
\item{lambda_preferred}{Lambdas of the preferred hypothesis. Has to be a
named vector with the names corresponding with the groups in the analyzed
data set. Alternatively, use the parameter labels.}

\item{lambda_competing}{Lambdas of the competing hypothesis. Has to be a
named vector with the names corresponding with the groups in the analyzed
data set. Alternatively, use the parameter labels.}

\item{labels}{If you provide lambdas without names, you can set the group
labels for both contrasts here.}
}
\value{
Lambdas for difference between lambda_preferred and lambda_competing
}
\description{
If you want to test two competing hypotheses, you can use this helper
function to create the correct difference lambdas. There is no magic here.
The two contrasts are z-standardized first and then subtracted
(lambda_preferred - lambda_competing). You can use the new difference lambdas
as the input for calc_contrast.
}
\examples{
lambda <- lambda_diff(c("A" = 1, "B" = 2, "C" = 3),
                      c("A" = 1, "B" = 2, "C" = 6))
lambda
# same result
lambda2 <- lambda_diff(c(1, 2, 3), c(1, 2, 6),
                       labels = c("A", "B", "C"))
lambda2
}
