% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhmc_mc.R
\name{mhmc_mc}
\alias{mhmc_mc}
\title{MHMC Parameter Estimates for Multiple Chains}
\usage{
mhmc_mc(
  chains = NULL,
  y = y,
  obj_fun = NULL,
  link = NULL,
  est_omega = TRUE,
  est_lambda = TRUE,
  est_zeta = TRUE,
  est_nu = TRUE,
  omega0 = NULL,
  gamma0 = NULL,
  lambda0 = NULL,
  zeta0 = NULL,
  nu0 = NULL,
  kappa0 = NULL,
  omega_mu = NULL,
  omega_sigma2 = NULL,
  lambda_mu = NULL,
  lambda_sigma2 = NULL,
  zeta_mu = NULL,
  zeta_sigma2 = NULL,
  nu_mu = NULL,
  nu_sigma2 = NULL,
  burn = NULL,
  thin = NULL,
  min_tune = NULL,
  tune_int = NULL,
  max_tune = NULL,
  niter = NULL,
  psrf = FALSE
)
}
\arguments{
\item{chains}{Number of chains in the MHMC sampler (scalar).}

\item{y}{Item response matrix (K by IJ).}

\item{obj_fun}{A function that calculates predictions and log-likelihood
values for the selected model (character).}

\item{link}{Choose between "logit" or "probit" link functions.}

\item{est_omega}{Determines whether omega is estimated (logical).}

\item{est_lambda}{Determines whether nu is estimated (logical).}

\item{est_zeta}{Determines whether zeta is estimated (logical).}

\item{est_nu}{Determines whether nu is estimated (logical).}

\item{omega0}{Starting or known values for omega (K by MN).}

\item{gamma0}{Starting or known values for gamma (JM by MN).}

\item{lambda0}{Starting or known values for lambda (IJ by JM).}

\item{zeta0}{Starting or known values for  zeta (K by JM).}

\item{nu0}{Starting or known values for nu (IJ by 1).}

\item{kappa0}{Starting or known values for kappa (1 by IJ).}

\item{omega_mu}{Mean prior for omega (1 by MN).}

\item{omega_sigma2}{Covariance prior for omega (MN by MN).}

\item{lambda_mu}{Mean prior for lambda (1 by JM)}

\item{lambda_sigma2}{Covariance prior for lambda (JM by JM)}

\item{zeta_mu}{Mean prior for zeta (1 by JM).}

\item{zeta_sigma2}{Covariance prior for zeta (JM by JM).}

\item{nu_mu}{Mean prior for nu (1 by 1)}

\item{nu_sigma2}{Covariance prior for nu (1 by 1)}

\item{burn}{Number of iterations at the beginning of an MCMC run to discard
(scalar).}

\item{thin}{Determines every nth observation retained (scalar).}

\item{min_tune}{Determines when tunning begins (scalar).}

\item{tune_int}{MHMC tuning interval (scalar).}

\item{max_tune}{Determines when tunning ends (scalar).}

\item{niter}{Number of iterations of the MHMC sampler.}

\item{psrf}{Estimate potential scale reduction factor (logical).}
}
\value{
List with elements omega_draws (draws from every saved iteration of
the MHMC sampler), omegaEAP (expected a posteriori estimates for omega),
omegaPSD (posterior standard deviation estimates for omega), omega_psrf
(potential scale reduction factor for omega), nuEAP (expected a posteriori
estimates for nu), nuPSD (posterior standard deviation estimates for nu),
nu_psrf (potential scale reduction factor for nu), zetaEAP (expected a
posteriori estimates for zeta), zetaPSD (posterior standard deviation
estimates for zeta), zeta_psrf (potential scale reduction factor for zeta).
}
\description{
This function calculates MHMC parameter estimates for multiple chains. See
documentation for mhmc_sc.R for more information.
}
\keyword{internal}
