% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{EdgIndCMap}
\alias{EdgIndCMap}
\title{Extract all edges from a Qualitative Data Analysis project for individual cognitive mapping}
\usage{
EdgIndCMap(project, min.weight = 1, weighted.icm = FALSE)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{min.weight}{A integer that will determine the minimum (>=) weight of relationships that will be taken into account. Relationships with a lower weight (<) will not be shown. Default is set to 1 (\emph{i.e.} all relationships are shown).}

\item{weighted.icm}{A boolean. If FALSE, the weight of the relationships in the ICM will be fixed to 1.}
}
\value{
A data.frame
}
\description{
This function opens a Qualitative Data Analysis (QDA) project and extracts edge information for individual cognitive mapping
}
\details{
The coding used in the QDA have to be done using the 'cogmap-dev' branch of the qcoder package (github : 'FrdVnW/qcoder'). devtools::install_github('FrdVnW/qcoder', ref = "cogmap-dev", upgrade = 'never')
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

EdgIndCMap(my.project)
}
