% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{create_experiment}
\alias{create_experiment}
\title{Create a new experiment}
\usage{
create_experiment(
  experiment_name = NULL,
  project_name = NULL,
  workspace_name = NULL,
  api_key = NULL,
  keep_active = TRUE,
  log_output = TRUE,
  log_error = FALSE,
  log_code = TRUE,
  log_system_details = TRUE,
  log_git_info = FALSE
)
}
\arguments{
\item{experiment_name}{Experiment name.}

\item{project_name}{Project name (can also be specified using the \code{COMET_PROJECT_NAME}
parameter as an environment variable or in a comet config file).}

\item{workspace_name}{Workspace name (can also be specified using the \code{COMET_WORKSPACE}
parameter as an environment variable or in a comet config file).}

\item{api_key}{Comet API key (can also be specified using the \code{COMET_API_KEY}
parameter as an environment variable or in a comet config file).}

\item{keep_active}{If \code{TRUE}, automatically send Comet a status update every
few seconds until the experiment is stopped to mark the experiment as active on the
Comet web dashboard.}

\item{log_output}{If \code{TRUE}, all standard output will automatically be sent to
the Comet servers to display as message logs for the experiment. The output will still
be shown in the console as well.}

\item{log_error}{If \code{TRUE}, all output from 'stderr' (which includes errors,
warnings, and messages) will be redirected to the Comet servers to display as message
logs for the experiment. Note that unlike \code{auto_log_output}, if this option is on then
these messages will not be shown in the console and instead they will only be logged
to the Comet experiment. This option is set to \code{FALSE} by default because of this
behavior.}

\item{log_code}{If \code{TRUE}, log the source code of the R script that was called
to Comet as the associated code of this experiment. This only works if the you run
a script using the \code{Rscript} tool and will not work in interactive sessions.}

\item{log_system_details}{If \code{TRUE}, automatically log the system details to
Comet when the experiment is created.}

\item{log_git_info}{If \code{TRUE}, log information about the active git repository.
Requires the \code{git2r} package to be installed.}
}
\value{
An \code{\link{Experiment}} object.
}
\description{
Create a new experiment on Comet's servers. The return value is an \code{\link{Experiment}}
object that can be used to modify or get information about the experiment. Only one
experiment can be active at a time, so make sure to stop an experiment before creating
a new one (by calling the \code{stop()} method on the \code{\link{Experiment}} object).
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables defined
exp <- create_experiment()
exp$get_key()
exp$get_metadata()
exp$add_tags(c("test", "tag2"))
exp$get_tags()
exp$log_metric("metric1", 5)
exp$get_metric("metric1")
exp$get_metrics_summary()
exp$stop()
}

}
