% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{nevaitpol}
\alias{nevaitpol}
\title{Neville-Aitken algorithm for polynomial interpolation}
\usage{
nevaitpol(x, f, x0)
}
\arguments{
\item{x}{A vector of real numbers. Grid points corresponding to the tabulated
(known) values of the function.}

\item{f}{A vector of real numbers. Tabulated (known) values of the function, 
corresponding to the grid \code{x}.}

\item{x0}{A vector of real numbers. These are the grid points chosen for
the interpolation. All points of this grid need to be 
within the tabulated grid.}
}
\value{
An upper triangular matrix of size n containing the
        linearly-interpolated values. \code{P[i,j]} is zero for 
        \eqn{i+j > n+1}.
}
\description{
Hierarchical series of linearly-interpolated \eqn{P_{ij}} values calculated using
Neville-Aitken's algorithm. In the \eqn{P_{ij}} expression, j is the level of the
algorithm and i the leftmost grid-point of the tabulated function points.
}
\examples{
# Tabulated values: f(x) = x^3-2*x^2+3*x-1
x <- c(0.1,0.4,0.6,0.8,0.9)
f <- x^3-2*x^2+3*x-1

# Interpolation point
x0 <- 0.75

# Upper-triangular matrix of N-A values
P <- nevaitpol(x,f,x0)

# From level 4 onward the interpolated value
# does not change because f(x) is a 3rd-degree polynomial
print(P)

}
