% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaCom.Dispersal.R
\name{MetaCom.Dispersal}
\alias{MetaCom.Dispersal}
\title{Seed dispersion in a metacommunity}
\usage{
MetaCom.Dispersal(n, before, m = 0.1, ...)
}
\arguments{
\item{n}{number of local (sub)communities}

\item{before}{A matrix of seed's attributes; seeds in rows, their location,
species identity and traits are in columns. Column that contains information on
locality has to be called 'site'}

\item{m}{probability that a seed are dispersed into other (sub)community}

\item{...}{Additional parameters. It necessary for thechnical reasons: the framework don't know the current list of parameters when call this function}
}
\value{
Same type of matrix as \code{before}
}
\description{
Seeds can disperse to any other local community with the same probability;
i.e. probability to disperse other subcommunity/(number local communities - 1). Each seed is dispersed independently.
}
\details{
Both input and output is a matrix where seeds are in the rows, and their
attributes (i.e. location, species identity and trait values) are in the
columns.
}
\seealso{
\code{\link{fDispersal}}
}
