% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{syms}
\alias{syms}
\alias{syms_with_errors}
\alias{syms_with_units}
\alias{syms_with_quantities}
\title{Lists of Constants}
\format{
A \code{list}, where names correspond to symbols in \code{codata$symbol}.
\itemize{
\item \code{syms} contains plain numeric values.
\item \code{syms_with_errors} contains objects of type \code{errors}, which
enables automatic uncertainty propagation.
\item \code{syms_with_units} contains objects of type \code{units}, which
enables automatic conversion, derivation and simplification.
\item \code{syms_with_quantities} contains objects of type \code{quantities},
which combines \code{errors} and \code{units}.
}
The enriched versions of \code{syms} are available only if the corresponding
optional packages, \pkg{errors}, \pkg{units} and/or \pkg{quantities} are
installed. See the documentation of these packages for further information.
}
\usage{
syms

syms_with_errors

syms_with_units

syms_with_quantities
}
\description{
These named lists contain ready-to-use values for all the fundamental
physical constants.
}
\details{
Experimental support for correlations between constants is provided via the
\pkg{errors} package, but it is disabled by default. To enable it, the
following option must be set before loading the package:

\code{options(constants.correlations=TRUE)}

Alternatively, \code{constants:::set_correlations()} may be used
interactively, but scripts should not rely on this non-exported function,
as it may disappear in future versions.
}
\examples{
# the speed of light
syms$c0
# use the constants in a local environment
with(syms, c0)

# attach only Planck-related constants
(lkp <- lookup("planck", ignore.case=TRUE))
idx <- as.integer(rownames(lkp))
attach(syms[idx])
h
plkl

# the same with uncertainty
detach(syms[idx])
attach(syms_with_errors[idx])
h
plkl

# the same with units
detach(syms_with_errors[idx])
attach(syms_with_units[idx])
h
plkl

# the same with everything
detach(syms_with_units[idx])
attach(syms_with_quantities[idx])
h
plkl

}
\seealso{
\code{\link{codata}}, \code{\link{lookup}}.
}
\keyword{datasets}
