% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_contrast.R
\name{use_contrasts.default}
\alias{use_contrasts.default}
\title{Default method for use_contrasts}
\usage{
\method{use_contrasts}{default}(
  factor_col,
  code_by = NA,
  reference_level = NA,
  set_intercept = NA,
  drop_trends = NA,
  labels = NULL,
  as_is = FALSE,
  ...
)
}
\arguments{
\item{factor_col}{A factor vector, eg from \code{df$factorVarName}}

\item{code_by}{Some object that's not a matrix or function. If NA, no warning
will be thrown, and the default contrasts will be used. A warning will be
thrown if it's not NA.}

\item{reference_level}{Not used}

\item{set_intercept}{Not used}

\item{drop_trends}{Not used}

\item{labels}{A vector of labels to apply to the matrix column names, default}

\item{as_is}{Logical, default FALSE, whether to leave the resulting matrix}

\item{...}{Additional arguments, not used}
}
\value{
Contrast matrix, using the ordered or unordered default from
\code{options()}
}
\description{
If a user doesn't specify a contrast matrix, use the defaults from options().
If the user tries to use something we don't know how to work with, throw a
warning that we'll be using the defaults from options().
}
\examples{
use_contrasts(gl(5,1), helmert_code) # a function
my_matrix <- helmert_code(5)
use_contrasts(gl(5,1), my_matrix) # a matrix

}
