% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append.R
\name{append}
\alias{append}
\alias{sysgroup}
\title{Append the dynamics of a set of systems}
\usage{
append(...)
}
\arguments{
\item{...}{Variable argument for LTI system models of tf, ss or zpk class}
}
\value{
The function returns a state-space model of the formed appended system with A, B, C, D matrices
}
\description{
\code{append} appends the dynamics of a set of n-state-space systems together
}
\details{
\code{append(sys1, sys2, sys3,...sysN)} first combines the the first two systems and then
goes on to combine  the resulting state-space system to the next system and so forth.
This is achieved by calling the \code{sysgroup(sys1, sys2)} at each iteration to group
the systems in consecutive pairs until all systems are
completely appended to form one system.

\code{sysgroup(sys1, sys2)} appends only two systems and is used by \code{append}

If a system is not in state-space representation, the function
tries to form a state-space representation for such system.
}
\examples{
sys1 <- ss(1,2,3,4)
sys2 <- ss(2,3,4,5)
sys3 <- ss(6,7,8,9)
append(sys1, sys2, sys3)
sys4 <- tf(1, c(1,2,5))
append(sys1, sys2, sys4)

}
\seealso{
\code{\link{series}} \code{\link{parallel}} \code{\link{feedback}} \code{\link{connect}}
}
