% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence_utilities.R
\name{plot_cor_heatmap}
\alias{plot_cor_heatmap}
\title{Plot Correlation Heatmap for a Single Dyad}
\usage{
plot_cor_heatmap(cor_matrix, titles)
}
\arguments{
\item{cor_matrix}{A correlation matrix for a single dyad}

\item{titles}{A character vector of titles for each similarity measure}
}
\value{
A ggplot object
}
\description{
Plot Correlation Heatmap for a Single Dyad
}
\details{
This function creates a heatmap of correlations between similarity measures for a single dyad.
}
\examples{
sim1 <- list(sequence = c(0.8, 0.7, 0.9), average = 0.8)
sim2 <- list(sequence = c(0.6, 0.8, 0.7), average = 0.7)
cor_matrix <- cor_sim_seq(list(sim1, sim2))
plot_cor_heatmap(cor_matrix, c("Topic", "Lexical"))
print(plot)
}
