% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fibonaccisphere.R
\name{fibonaccisphere}
\alias{fibonaccisphere}
\title{Evenly distributed n points on a sphere}
\usage{
fibonaccisphere(n = 1000, r = 1, out.xyz = TRUE, out.sph = FALSE)
}
\arguments{
\item{n}{number of points to be placed on the sphere}

\item{r}{radius}

\item{out.xyz}{logical flag specifying whether to return Cartesian coordinates (default is TRUE)}

\item{out.sph}{logical flag specifying whether to return spherical coordinates (default is FALSE); \code{theta}=colatitute (=polar angle=angle from z-axis), \code{phi}=longitude (=azimuth angle),}
}
\value{
matrix of n points (in n rows), in Cartesian and/or spherical coordinates.
}
\description{
Distributes n points on a sphere in a relatively even fashion following the generalised Fibonacci algorithm, described at http://extremelearning.com.au/evenly-distributing-points-on-a-sphere/
}
\examples{
## plot standard projections of a 1000-point Fibonacci sphere
xyz = fibonaccisphere()
plot(xyz, asp=1, pch=16, cex=0.5)

}
\seealso{
\code{\link{runif3}}
}
\author{
Danail Obreschkow
}
