/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter.objectives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.corehunter.data.CoreHunterData;
import org.corehunter.objectives.distance.DistanceMeasure;
import org.corehunter.objectives.distance.eval.NearestEntry;
import org.corehunter.objectives.distance.eval.NearestEntryEvaluation;
import org.corehunter.objectives.distance.measures.MissingValuesPolicy;
import org.jamesframework.core.exceptions.IncompatibleDeltaEvaluationException;
import org.jamesframework.core.problems.objectives.Objective;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.subset.SubsetSolution;
import org.jamesframework.core.subset.neigh.moves.SubsetMove;

public class AverageEntryToNearestEntry
implements Objective<SubsetSolution, CoreHunterData> {
    private final DistanceMeasure distanceMeasure;

    public AverageEntryToNearestEntry(DistanceMeasure distanceMeasure) {
        this.distanceMeasure = distanceMeasure;
        distanceMeasure.setMissingValuesPolicy(MissingValuesPolicy.FLOOR);
    }

    public NearestEntryEvaluation evaluate(SubsetSolution solution, CoreHunterData data) {
        NearestEntryEvaluation eval = new NearestEntryEvaluation(0.0);
        Set<Integer> selected = solution.getSelectedIDs();
        for (int sel : selected) {
            NearestEntry closest = this.findClosest(sel, selected, data);
            if (closest == null) continue;
            eval.add(sel, closest);
        }
        return eval;
    }

    public NearestEntryEvaluation evaluate(Move move, SubsetSolution curSolution, Evaluation curEvaluation, CoreHunterData data) {
        if (!(move instanceof SubsetMove)) {
            throw new IncompatibleDeltaEvaluationException("Entry-to-nearest-entry distance objective should be used in combination with neighbourhoods that generate moves of type SubsetMove.");
        }
        SubsetMove subsetMove = (SubsetMove)move;
        NearestEntryEvaluation eval = (NearestEntryEvaluation)curEvaluation;
        NearestEntryEvaluation newEval = new NearestEntryEvaluation(eval);
        Set<Integer> added = subsetMove.getAddedIDs();
        Set<Integer> deleted = subsetMove.getDeletedIDs();
        Set<Integer> curSelection = curSolution.getSelectedIDs();
        ArrayList<Integer> newSelection = new ArrayList<Integer>(curSelection);
        newSelection.addAll(added);
        newSelection.removeAll(deleted);
        for (int item : deleted) {
            newEval.remove(item);
        }
        for (int item : newSelection) {
            NearestEntry newClosest;
            NearestEntry curClosest = newEval.getClosest(item);
            if (curClosest == null) {
                newClosest = this.findClosest(item, newSelection, data);
                if (newClosest == null) continue;
                newEval.add(item, newClosest);
                continue;
            }
            if (deleted.contains(curClosest.getId())) {
                newClosest = this.findClosest(item, newSelection, data);
                if (newClosest != null) {
                    newEval.update(item, newClosest);
                    continue;
                }
                newEval.remove(item);
                continue;
            }
            NearestEntry closestAddedItem = this.findClosest(item, added, data);
            if (closestAddedItem == null || !(closestAddedItem.getDistance() < curClosest.getDistance())) continue;
            newEval.update(item, closestAddedItem);
        }
        return newEval;
    }

    private NearestEntry findClosest(int itemId, Collection<Integer> group, CoreHunterData data) {
        Double minDist = Double.POSITIVE_INFINITY;
        Integer closest = null;
        for (int other : group) {
            double dist;
            if (other == itemId || !((dist = this.distanceMeasure.getDistance(itemId, other, data)) < minDist)) continue;
            minDist = dist;
            closest = other;
        }
        return closest != null ? new NearestEntry(closest, minDist) : null;
    }

    @Override
    public boolean isMinimizing() {
        return false;
    }

    public String toString() {
        return "Average entry to nearest entry (" + this.distanceMeasure + ")";
    }
}

