% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{do_sim}
\alias{do_sim}
\title{Function to simulate agreement patterns for record pairs from a mixture model}
\usage{
do_sim(cor_match = 0.1, cor_mismatch = 0, nsample = 10^3,
  pi_match = 0.01, m_probs, u_probs, missingprobs)
}
\arguments{
\item{cor_match}{correlation in 0/1 agreement fields for record pairs constituting the same individual (matches).}

\item{cor_mismatch}{correlation in 0/1 agreement fields for record pairs not constituting the same individual (true mismatches).}

\item{nsample}{number of record pairs to simulate.}

\item{pi_match}{the probability both records from a randomly selected record pair correspond to the same individual (a true match).}

\item{m_probs}{marginal probabilities of agreement for each field for record pairs constituting true matches.}

\item{u_probs}{marginal probabilities of agreement for each field for record pairs constituting true mismatches.}

\item{missingprobs}{probabilities that each field is missing on at least one record pair.}
}
\value{
A matrix of the simulated agreement patterns, with final column equal to the count of each pattern.
}
\description{
Function to simulate agreement patterns for record pairs from a mixture model
}
\examples{
m_probs <- rep(0.8,6)
u_probs <- rep(0.2,6)
means_match <- -1*qnorm(1-m_probs)
means_mismatch <- -1*qnorm(1-u_probs)
missingprobs <- rep(.2,6)
thedata <- do_sim(cor_match=0.2,cor_mismatch=0,nsample=10^4,
pi_match=.5,m_probs=rep(0.8,5),u_probs=rep(0.2,5),missingprobs=rep(0.4,5))
thedata
}
\keyword{internal}

