% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsyntax.r
\name{tCorpus$fold_rsyntax}
\alias{tCorpus$fold_rsyntax}
\title{Fold rsyntax annotations}
\arguments{
\item{annotation}{The name of an rsyntax annotation column}

\item{by_label}{The labels in this column for which you want to aggregate the tokens}

\item{...}{Specify the new aggregated columns in name-value pairs. The name is the name of the new column, and the value should be a function over a column in $tokens. 
For example:  subject = paste(token, collapse = ' ')  would create the column 'subject', of which the values are the concatenated tokens. See examples for more.}

\item{txt}{If TRUE, add _txt column with concatenated tokens for by_label}

\item{rm_by}{If TRUE (default), remove the column(s) specified in by_label}

\item{copy}{If TRUE, return a copy of the transformed tCorpus, instead of transforming the tCorpus by reference}
}
\description{
If a tCorpus has rsyntax annotations, it can be convenient to aggregate tokens that have a certain semantic label.
For example, if you have a query for labeling "source" and "quote", you can add an aggegated value for the sources (such as a unique ID) as a column, and then remove the quote tokens.
}
\details{
\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{
fold_rsyntax(annotation, by_label, ..., 
             to_label=NULL, rm_by=T, copy=F)}
}
\examples{
tc = tc_sotu_udpipe$copy()
tc$udpipe_clauses()

tc$fold_rsyntax('clause', by_label = 'subject', subject = paste(token, collapse=' '))
tc$tokens
}
